/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.config.schedule;

import com.floragunn.codova.config.temporal.DurationFormat;
import com.floragunn.searchsupport.jobs.config.schedule.Schedule;
import com.floragunn.searchsupport.jobs.config.schedule.elements.DailyTrigger;
import com.floragunn.searchsupport.jobs.config.schedule.elements.HumanReadableCronTrigger;
import com.floragunn.searchsupport.jobs.config.schedule.elements.MonthlyTrigger;
import com.floragunn.searchsupport.jobs.config.schedule.elements.WeeklyTrigger;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.quartz.CronTrigger;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class ScheduleImpl
implements Schedule {
    private List<Trigger> triggers;

    public ScheduleImpl(List<Trigger> triggers) {
        this.triggers = Collections.unmodifiableList(triggers);
    }

    @Override
    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        List<MonthlyTrigger> list;
        List<WeeklyTrigger> list2;
        List<DailyTrigger> dailyTriggers;
        List<SimpleTrigger> simpleTriggers;
        List<CronTrigger> cronTriggers;
        builder.startObject();
        TimeZone timeZone = this.getTimeZone();
        if (timeZone != null) {
            builder.field("timezone", timeZone.getID());
        }
        if ((cronTriggers = this.getCronTriggers()).size() > 0) {
            builder.field("cron").startArray();
            for (CronTrigger trigger : cronTriggers) {
                builder.value(trigger.getCronExpression());
            }
            builder.endArray();
        }
        if ((simpleTriggers = this.getIntervalTriggers()).size() > 0) {
            builder.field("interval").startArray();
            for (SimpleTrigger simpleTrigger : simpleTriggers) {
                builder.value(DurationFormat.INSTANCE.format(Duration.ofMillis(simpleTrigger.getRepeatInterval())));
            }
            builder.endArray();
        }
        if ((dailyTriggers = this.getTriggers(DailyTrigger.class)).size() > 0) {
            builder.field("daily").startArray();
            for (DailyTrigger dailyTrigger : dailyTriggers) {
                dailyTrigger.toXContent(builder, params);
            }
            builder.endArray();
        }
        if ((list2 = this.getTriggers(WeeklyTrigger.class)).size() > 0) {
            builder.field("weekly").startArray();
            for (WeeklyTrigger trigger : list2) {
                trigger.toXContent(builder, params);
            }
            builder.endArray();
        }
        if ((list = this.getTriggers(MonthlyTrigger.class)).size() > 0) {
            builder.field("monthly").startArray();
            for (MonthlyTrigger trigger : list) {
                trigger.toXContent(builder, params);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    private TimeZone getTimeZone() {
        if (this.triggers == null) {
            return null;
        }
        for (Trigger trigger : this.triggers) {
            if (trigger instanceof CronTrigger) {
                return ((CronTrigger)trigger).getTimeZone();
            }
            if (!(trigger instanceof HumanReadableCronTrigger)) continue;
            return ((HumanReadableCronTrigger)trigger).getTimeZone();
        }
        return null;
    }

    private List<CronTrigger> getCronTriggers() {
        ArrayList<CronTrigger> result = new ArrayList<CronTrigger>(this.triggers.size());
        for (Trigger trigger : this.triggers) {
            if (!(trigger instanceof CronTrigger)) continue;
            result.add((CronTrigger)trigger);
        }
        return result;
    }

    private List<SimpleTrigger> getIntervalTriggers() {
        ArrayList<SimpleTrigger> result = new ArrayList<SimpleTrigger>(this.triggers.size());
        for (Trigger trigger : this.triggers) {
            if (!(trigger instanceof SimpleTrigger)) continue;
            result.add((SimpleTrigger)trigger);
        }
        return result;
    }

    private <X extends Trigger> List<X> getTriggers(Class<X> type) {
        ArrayList<Trigger> result = new ArrayList<Trigger>(this.triggers.size());
        for (Trigger trigger : this.triggers) {
            if (!type.isAssignableFrom(trigger.getClass())) continue;
            Trigger typedTrigger = trigger;
            result.add(typedTrigger);
        }
        return result;
    }

    public String toString() {
        return this.triggers.toString();
    }
}

